//===============================================================================================
// Methods to support the display of the common side bar
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

// Sidebar items
kLinks = new Array(
	'<a href="javascript:goTechSupport()">Tech Support</a>',
	'<a href="javascript:goLiveAdvice()">Tax Advice</a>',
	'<a href="javascript:parent.goFeedback()">Send Feedback</a>'
);

// Tax Help Links
taxHelpLinks = new Array
(
	'<a href="javascript:goTechSupport()">IRS Publications</a>',
	'<a href="javascript:goLiveAdvice()">Talk to a Tax Advisor</a>',
	'<a href="javascript:goProReview()">Professional Review</a>'
);

// Description for the links
kDescriptions = new Array(
	"Find answers on our website, or talk with a technical support representative by phone or by chat.",
	"Get one-on-one help for your specific tax situation.",
	"Before you file, have a tax professional review your return."
);

kFeedbackLink = '<a href="javascript:parent.goFeedback()">send us a note</a>';


//-----------------------------------------------------------------------------------------------
function createSidebar()
	// Returns the sidebar element
{
	var div = document.createElement( "div" );
	
	var tbl = document.createElement( "table" );
	tbl.className = "sidebar";
	tbl.cols = 2;
	tbl.cellSpacing = 0;
	tbl.cellPadding = 0;
	tbl.border = 0;
	tbl.width = 10; // keep the width to a minimum
	
	tbl.appendChild( _createSidebarHeader( tbl, "Contact Us" ) );  // was Still Need Help?
	tbl.appendChild( _createSidebarItems( tbl ) );

	tbl.appendChild( _createSidebarHeader( tbl, "Provide Feedback" ) );
	tbl.appendChild( _createSidebarFeedbackItem( tbl ) );
	
	div.appendChild( tbl );
	
	// Privacy link
	var privDiv = document.createElement( "div" );
	privDiv.className = "sidebarPrivacyLnk";
	privDiv.innerHTML = '<a href="javascript:goPrivacy()">Privacy Statement</a>';	
	div.appendChild( privDiv );

	return div;
}

//-----------------------------------------------------------------------------------------------
function _createSidebarHeader( tbl, label )
	// Returns a sidebar header
{
	var row = tbl.insertRow();
	var cell = row.insertCell();
	
	cell.colSpan = 2;
	cell.noWrap = true;
	cell.className = "header";
	cell.innerHTML = label;
	
	var hd = document.createElement( "tHead" );
	hd.appendChild( row );

	return hd;
}

//-----------------------------------------------------------------------------------------------
function _createSidebarItems( tbl )
	// Returns the element displaying the sidebar items
{
	var bd = document.createElement( "tBody" );
	var cnt = kLinks.length;
	
	for( var i=0; i<cnt; ++i ) _appendSidebarItem( tbl, bd, kLinks[i], kDescriptions[i] );
	
	_appendSidebarSeparator( tbl, bd );
	
	return bd;
}

//-----------------------------------------------------------------------------------------------
function _appendSidebarItem( tbl, bd, lnk, desc, bLast )
	// Create the sidebar items and append it to the specified table body
{
	var row = tbl.insertRow();
	var cell = row.insertCell();
	
	// bullet
	cell.className = "bullet";
	cell.innerHTML = "&#108;";
	
	// link
	cell = row.insertCell();
	cell.className = "item";
	cell.noWrap = true;
	cell.innerHTML = lnk;
	
	bd.appendChild( row );
	
	// description
	row = tbl.insertRow();
	cell = row.insertCell();
	cell.className = "left";
	cell.innerHTML = "&nbsp;";

	cell = row.insertCell();
	cell.className = "desc";
	cell.innerHTML = desc;

	bd.appendChild( row );
}

//-----------------------------------------------------------------------------------------------
function _appendSidebarSeparator( tbl, bd )
	// Create and append a spacer row
{
	var row = tbl.insertRow();
	var cell = row.insertCell();
	cell.className = "separator";
	cell.colSpan = 2;
	cell.innerHTML = "&nbsp";
	
	bd.appendChild( row );
}	

//-----------------------------------------------------------------------------------------------
function _createSidebarFeedbackItem( tbl )
	// Create the element containing the feedback link
{
	var row = tbl.insertRow();
	var cell = row.insertCell();
	cell.className = "left";
	cell.innerHTML = "&nbsp";

	cell = row.insertCell();
	cell.className = "note";

	var s = 'If you didn\'t find what you were looking for, please ';
	s += kFeedbackLink + '.';

	cell.innerHTML = s;
	
	var bd = document.createElement( "tBody" );	
	bd.appendChild( row );
	
	return bd;
}

//-----------------------------------------------------------------------------------------------
function goProReview()
{
	var h = screen.availHeight - 10;
	if( h > 910 ) h = 910;

	var opt = "dialogWidth:720px;dialogHeight:" + h + "px;help:No;resizable:Yes;status:No;scroll:Yes;"
	showModelessDialog( "proReviewIntro.htm", null, opt );
}

//-----------------------------------------------------------------------------------------------
function goTechSupport(){ parent.onCmd("doTechSupportNoContext"); }
function goLiveAdvice(){ parent.onCmd("doLiveAdvice"); }
function goPrivacy(){ parent.onCmd("doPrivacy"); }
	// Ask the C++ handler to take care of displaying the appropriate live site
